﻿#nullable enable
namespace Hims.Shared.UserModels.Pharmacy
{
    using System;

    /// <summary>
    /// The pharmacy dashboard model.
    /// </summary>
    public class PharmacyDashboardModel
    {
        /// <summary>
        /// Gets or sets the product group for tender identifier.
        /// </summary>
        /// <value>
        /// The product group for tender identifier.
        /// </value>
        public int? ProductGroupForTenderId { get; set; }

        /// <summary>
        /// Gets or sets the available qty.
        /// </summary>
        /// <value>
        /// The available qty.
        /// </value>
        public int AvailableQty { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string? ProductName { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string? BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string? Status { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the barcode.
        /// </summary>
        public string? Barcode { get; set; }

        /// <summary>
        /// Gets or sets the generic name.
        /// </summary>
        public string? GenericName { get; set; }

        /// <summary>
        /// Gets or sets the rol quantity.
        /// </summary>
        public int RolQuantity { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy Product Id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the name of the retail.
        /// </summary>
        /// <value>
        /// The name of the retail.
        /// </value>
        public string? RetailName { get; set; }

        /// <summary>
        /// Gets or sets the name of the ware house.
        /// </summary>
        /// <value>
        /// The name of the ware house.
        /// </value>
        public string? WareHouseName { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house identifier.
        /// </summary>
        /// <value>
        /// The pharmacy ware house identifier.
        /// </value>
        public int? PharmacyWareHouseId { get; set; }

        /// <summary>
        /// Gets or sets the retail pharmacy identifier.
        /// </summary>
        /// <value>
        /// The retail pharmacy identifier.
        /// </value>
        public int? RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the roq.
        /// </summary>
        /// <value>
        /// The roq.
        /// </value>
        public int? ROQ { get; set; }

        /// <summary>
        /// Gets or sets the rol.
        /// </summary>
        /// <value>
        /// The rol.
        /// </value>
        public int? ROL { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string? CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the retail store name.
        /// </summary>
        public string? RetailStoreName { get; set; }

        /// <summary>
        /// Gets or sets the stock identifier.
        /// </summary>
        /// <value>
        /// The stock identifier.
        /// </value>
        public string? StockId { get; set; }

    }
}
