﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The pharmacy retail ware user.
    /// </summary>
    public class RetailWareUser
    {
        /// <summary>
        /// Gets or sets the pharmacy allowed user fullname.
        /// </summary>
        /// <value>
        /// The pharmacy allowed user fullname.
        /// </value>

        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy ware house Name.
        /// </summary>
        /// <value>
        /// The pharmacy ware house Name.
        /// </value>
        public string WareHouseName { get; set; }

        /// <summary>
        /// Gets or sets retail name.
        /// </summary>
        /// <value>
        /// The retail name.
        /// </value>
       public string RetailName { get; set; }

        /// <summary>
        /// Gets or sets accountId
        /// </summary>
        /// <value>
        /// The account id.
        /// </value>
        public int AccountId { get; set; }
    }
}


