﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// TelemedicineTemplateHistory
    /// </summary>
    public class TelemedicineTemplateHistory
    {
        /// <summary>
        /// Gets or sets the telemedicine template history identifier.
        /// </summary>
        /// <value>
        /// The telemedicine template history identifier.
        /// </value>
        [Key, Identity]
        public int TelemedicineTemplateHistoryId { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine template identifier.
        /// </summary>
        /// <value>
        /// The telemedicine template identifier.
        /// </value>
        public int TelemedicineTemplateId { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine call history identifier.
        /// </summary>
        /// <value>
        /// The telemedicine call history identifier.
        /// </value>
        public int TelemedicineCallHistoryId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="TelemedicineTemplateHistory"/> is status.
        /// </summary>
        /// <value>
        ///   <c>true</c> if status; otherwise, <c>false</c>.
        /// </value>
        public bool Status { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }
    }
}