﻿using System.Collections.Generic;

namespace Hims.Domain.Services
{
    using System.Threading.Tasks;
    using Shared.UserModels.Discharge;
    using Resource = Shared.UserModels.Discharge.Resource;

    /// <summary>
    /// The CompanyService interface.
    /// </summary>
    public interface IDischargeService
    {
        /// <summary>
        /// Fetches the discharge instructions asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource.ViewModel>> FetchDischargeInstructionsAsync();

        /// <summary>
        /// Fetches the discharge status asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<Resource.ViewModel>> FetchDischargeStatusAsync();

        /// <summary>
        /// The insert company async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> InsertAsync(InsertModel model);

        /// <summary>
        /// The update bed status async.
        /// </summary>
        /// <param name="admissionId">
        /// The admission Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateBedStatusAsync(int admissionId);

        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(UpdateModel model);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<ViewModel> FetchAsync(FilterModel model);

        /// <summary>
        /// The insert discharge async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> InsertDischargeAsync(InsertModel model);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<ViewModel> FetchDischargeAsync(FilterModel model);

        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateDischargeAsync(UpdateModel model);
    }
}
