﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels.NurseShift;
    using Hims.Shared.UserModels.NurseShift.Bed;

    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface INurseShiftService
    {
        Task<string> CopyShiftsAsync(CopyPayload model);

        /// <summary>
        /// Fetches the moves asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<MoveViewModel>> FetchMovesAsync(GetPayload model);

        /// <summary>
        /// Moves the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> MoveAsync(MoveModel model);

        /// <summary>
        /// Fetches the beds basic asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<BasicBedModel>> FetchBedsBasicAsync(GetPayload model);

        /// <summary>
        /// Fetches the beds asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<BedModel>> FetchBedsAsync(BedFilterModel model);

        /// <summary>
        /// Gets the nurse asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<NurseDetailsModel> GetNurseAsync(GetPayload model);

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(InsertModel model);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ViewModel>> FetchAsync(GetPayload model);

        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(UpdateModel model);
    }
}
