﻿namespace Hims.Domain.Services
{
    using System.Threading.Tasks;
    using System;

    using Hims.Shared.UserModels;
    using System.Collections.Generic;
    using Hims.Shared.UserModels.Scan.ScanMachine;

    /// <summary>
    /// The InternalMedicineService interface.
    /// </summary>
    public interface IScanMachineService
    {
        /// <summary>
        /// The add machine async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(ScanMachineInsertModel model);

        /// <summary>
        /// The add machine async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ModifyImportAsync(MachineImportModel model);

        /// <summary>
        /// The update alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(ScanMachineInsertModel model);

        /// <summary>
        /// The fetch alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ScanMachineFetchModel>> FetchAllScanMachineTests(ScanMachineFetchModel model);

        /// <summary>
        /// The fetch alt async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ScanMachineFetchModel>> FetchImportMachineTests(ScanMachineFetchModel model);

        /// <summary>
        /// Activates the or deactivate ware house.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ActivateOrDeactivateMachine(ScanMachineFetchModel model);
    }
}
