﻿namespace Hims.Shared.UserModels.Pharmacy
{
    using System;

    /// <summary>
    /// The department consumption model.
    /// </summary>
    public class DepartmentConsumptionModel
    {
        /// <summary>
        /// Gets or sets the department consumption identifier.
        /// </summary>
        /// <value>
        /// The department consumption identifier.
        /// </value>
        public int DepartmentConsumptionId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy departmental stock identifier.
        /// </summary>
        /// <value>
        /// The pharmacy departmental stock identifier.
        /// </value>
        public int? PharmacyDepartmentalStockId { get; set; }

        /// <summary>
        /// Gets or sets the quantity consumed.
        /// </summary>
        /// <value>
        /// The quantity consumed.
        /// </value>
        public int QuantityConsumed { get; set; }

        /// <summary>
        /// Gets or sets the consumed by.
        /// </summary>
        /// <value>
        /// The consumed by.
        /// </value>
        public int? ConsumedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the reason for consumption.
        /// </summary>
        /// <value>
        /// The reason for consumption.
        /// </value>
        public string ReasonForConsumption { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the consumed by.
        /// </summary>
        /// <value>
        /// The name of the consumed by.
        /// </value>
        public string ConsumedByName { get; set; }

        /// <summary>
        /// Gets or sets the consumed by role.
        /// </summary>
        /// <value>
        /// The consumed by role.
        /// </value>
        public string ConsumedByRole { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by role.
        /// </summary>
        /// <value>
        /// The created by role.
        /// </value>
        public string CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        /// <value>
        /// The batch number.
        /// </value>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        /// <value>
        /// The expiry date.
        /// </value>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the stock credited date.
        /// </summary>
        /// <value>
        /// The stock credited date.
        /// </value>
        public DateTime StockCreditedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the product.
        /// </summary>
        /// <value>
        /// The name of the product.
        /// </value>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the name of the category.
        /// </summary>
        /// <value>
        /// The name of the category.
        /// </value>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the name of the generic.
        /// </summary>
        /// <value>
        /// The name of the generic.
        /// </value>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        /// <value>
        /// The tax percentage.
        /// </value>
        public int TaxPercentage { get; set; }

        /// <summary>
        /// Gets or sets the quantity in.
        /// </summary>
        /// <value>
        /// The quantity in.
        /// </value>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the quantity out.
        /// </summary>
        /// <value>
        /// The quantity out.
        /// </value>
        public int QuantityOut { get; set; }

        /// <summary>
        /// Gets or sets from date.
        /// </summary>
        /// <value>
        /// From date.
        /// </value>
        public string FromDate { get; set; }

        /// <summary>
        /// Converts to date.
        /// </summary>
        /// <value>
        /// To date.
        /// </value>
        public string ToDate { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product ids.
        /// </summary>
        /// <value>
        /// The pharmacy product ids.
        /// </value>
        public string PharmacyProductIds { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy department identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department identifier.
        /// </value>
        public int? PharmacyDepartmentId { get; set; }
    }
}
