﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Shared.UserModels
{

    /// <inheritdoc />
    public class ReferralDoctorModel
    {
        
        /// <summary>
        /// Gets or sets the ReferralDoctor id.
        /// </summary>
        [Key, Identity]
        public int ReferralDoctorId { get; set; }

        /// <summary>
        /// Gets or sets the Salutation.
        /// </summary>
        public string Salutation { get; set; }

        /// <summary>
        /// Gets or sets the First name.
        /// </summary>
        public string FirstName { get; set; }

        /// <summary>
        /// Gets or sets the Last name.
        /// </summary>
        public string LastName { get; set; }

        /// <summary>
        /// Gets or sets the Mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the Email.
        /// </summary>
        public string Email { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the Location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the Location name.
        /// </summary>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

    }
}
