﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities
{
    public class EncountersLog
    {
        /// <summary>
        /// Gets or sets the encounter LogId.
        /// </summary>
        [Key, Identity]
        public int EncounterLogId { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public int EncounterTypeId { get; set; }

        /// <summary>
        /// Gets or sets the log date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime LogDate { get; set; }

        /// <summary>
        /// Gets or sets the app type.
        /// </summary>
        public short LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the user id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the encounterLog code.
        /// </summary>
        public string LogDescription { get; set; }

        /// <summary>
        /// Gets or sets the Location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the Section.
        /// </summary>
        public string Section { get; set; }
    }
}
