﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels;

    /// <summary>
    /// The Machine  Service interface.
    /// </summary>
    public interface IMachineService
{
    /// <summary>
    /// Inserts the asynchronous.
    /// </summary>
    /// <param name="model">The model.</param>
    /// <returns></returns>
    Task<int> InsertAsync(MachineModel model);

    /// <summary>
    /// Fetches all asynchronous.
    /// </summary>
    /// <param name="model">The model.</param>
    /// <returns></returns>
    Task<IEnumerable<MachineModel>> FetchAllAsync(MachineModel model);

    ///// <summary>
    ///// Fetches all asynchronous.
    ///// </summary>
    ///// <param name="model">The model.</param>
    ///// <returns></returns>
    //Task<IEnumerable<MachineModel>> FetchActiveAllAsync(MachineModel model);

    /// <summary>
    /// Updates the asynchronous.
    /// </summary>
    /// <param name="model">The model.</param>
    /// <returns></returns>
    Task<int> UpdateAsync(MachineModel model);

   

    /// <summary>
    /// Activates the or deactivate  the machine
    /// </summary>
    /// <param name="model">The model.</param>
    /// <returns></returns>
    Task<int> ActivateOrDeactivateMachine(MachineModel model);
}
}
