﻿using Hims.Shared.UserModels.Vaccine;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Domain.Services
{
    /// <summary>
    /// The vaccine service interface.
    /// </summary>
    public interface IVaccineService
    {
        /// <summary>
        /// Modifies the vaccine group.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyVaccineGroupAsync(VaccineGroupModel model);

        /// <summary>
        /// Gets all vaccine groups asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<VaccineGroupModel>> GetAllVaccineGroupsAsync(VaccineGroupModel model);

        /// <summary>
        /// Deletes the vaccine group asynchronous.
        /// </summary>
        /// <param name="groupId">The group identifier.</param>
        /// <returns></returns>
        Task<int> DeleteVaccineGroupAsync(int groupId);

        /// <summary>
        /// Modifies the vaccine master.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyVaccineMaster(VaccineMasterModel model);

        /// <summary>
        /// Sets the vaccine master order asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> SetVaccineMasterOrderAsync(List<VaccineMasterModel> model);

        /// <summary>
        /// Fetches the vaccine masters asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<VaccineMasterModel>> FetchVaccineMastersAsync(VaccineMasterModel model);

        /// <summary>
        /// Fetches all vaccine types asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<VaccineTypeModel>> FetchAllVaccineTypesAsync();

        /// <summary>
        /// Changes the vaccine active status asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ChangeVaccineActiveStatusAsync(VaccineMasterModel model);

        /// <summary>
        /// Fetches the vaccine age group asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<IEnumerable<VaccineAgeGroupModel>> FetchVaccineAgeGroupAsync();

        /// <summary>
        /// Modifies the vaccine pharmacy link asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyVaccinePharmacyLinkAsync(VaccinePharmacyLinkHeaderModel model);

        /// <summary>
        /// Fetches the vaccine pharma link asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<VaccinePharmacyLinkHeaderModel>> FetchVaccinePharmaLinkAsync(VaccinePharmacyLinkHeaderModel model);

        /// <summary>
        /// Deletes the pharmacy link asynchronous.
        /// </summary>
        /// <param name="headerId">The header identifier.</param>
        /// <returns></returns>
        Task<int> DeletePharmacyLinkAsync(int headerId);

        /// <summary>
        /// Fetches the vaccines with pharmacy product information asynchronous.
        /// </summary>
        /// <param name="vaccineMasterId">The vaccine master identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<VaccinePharmacyLinkDetailModel>> FetchVaccinesWithPharmacyProductInformationAsync(int vaccineMasterId);

        /// <summary>
        /// Adds the immunization order asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddImmunizationOrderAsync(ImmunizationHistoryModel model);

        /// <summary>
        /// Checks the product from sales bill asynchronous.
        /// </summary>
        /// <param name="patientId">The patient identifier.</param>
        /// <param name="pharmacyProductId">The pharmacy product identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<ImmunizationHistoryModel>> CheckProductFromSalesBillAsync(int patientId, string pharmacyProductId);

        /// <summary>
        /// Gives the vaccine asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> GiveVaccineAsync(ImmunizationHistoryModel model);

        /// <summary>
        /// Fetches the immunization history asynchronous.
        /// </summary>
        /// <param name="patientId">The patient identifier.</param>
        /// <returns></returns>
        Task<IEnumerable<ImmunizationHistoryModel>> FetchImmunizationHistoryAsync(int patientId);
    }
}
