﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class RoomCharge
    {
        /// <summary>
        /// Gets or sets the room charge  id.
        /// </summary>
        [Key, Identity]
        public int RoomChargeId { get; set; }

        /// <summary>
        /// Gets or sets the charge category id.
        /// </summary>
        public int ChargeCategoryId { get; set; }
        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }
              
        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public double Cost { get; set; }
              
        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime? CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public bool Active { get; set; }
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }
        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

    }
}
