﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities
{
    public class ScanMachineAvailability
    {
        /// <summary>
        /// Gets or sets the scan machine availability id.
        /// </summary>
        [Key, Identity]
        public int ScanMachineAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the scan machine master id.
        /// </summary>
        public int ScanMachineMasterId { get; set; }

        /// <summary>
        /// Gets or sets the available days.
        /// </summary>
        public string AvailableDays { get; set; }

        /// <summary>
        /// Gets or sets the Availability.
        /// </summary>
        public string Availability { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }


        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public DateTime? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public DateTime? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the from time.
        /// </summary>
        public string FromTime { get; set; }

        /// <summary>
        /// Gets or sets the to time.
        /// </summary>
        public string ToTime { get; set; }

        /// <summary>
        /// Gets or sets the referecne break id.
        /// </summary>
        public int? ReferenceBreakId { get; set; }

        /// <summary>
        /// Gets or sets the reference block id.
        /// </summary>
        public int? ReferenceBlockId { get; set; }

        /// <summary>
        /// Gets or sets the scan week id.
        /// </summary>
        public int? ScanWeekId { get; set; }

        /// <summary>
        /// Gets or sets the available date.
        /// </summary>
        public string? AvailableDate { get; set; }
    }
}
