﻿using System;

namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Charge = Shared.UserModels.ServiceOrder.Charge;
    using Admission = Shared.UserModels.ServiceOrder.Admission;
    using PharmacyIndent = Shared.UserModels.ServiceOrder.PharmacyIndent;
    using Package = Shared.UserModels.ServiceOrder.Package;
    using Shared.UserModels.ServiceOrder;
    using Hims.Shared.UserModels.Common;
    using Hims.Shared.UserModels.Laboratory;
    using Hims.Shared.UserModels.Labs;
    using Hims.Shared.UserModels.ServiceOrder.Counselling;

    /// <summary> The ChatService interface.</summary>
    public interface IServiceOrderService
    {
        Task<int> ApplyCounsellingAsync(AutomaticFilterModel model);

        Task<IEnumerable<basicCounsellingModel>> GetCounsellingsAsync(AutomaticFilterModel model);

        /// <summary>
        /// Fetches the packages asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PackageModuleModel>> FetchPackagesAsync(FilterModel model);

        /// <summary>
        /// Inserts the package asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertPackageAsync(Package.InsertModel model);

        /// <summary>
        /// Determines whether [is first time asynchronous] [the specified model].
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<bool> IsFirstTimeAsync(AutomaticFilterModel model);

        /// <summary>
        /// Determines whether [is automatic possible asynchronous] [the specified admission identifier].
        /// </summary>
        /// <param name="admissionId">The admission identifier.</param>
        /// <returns></returns>
        Task<bool> IsAutomaticPossibleAsync(int admissionId);

        /// <summary>
        /// Automatics the insert asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AutomaticInsertAsync(AutomaticInsertModel model);

        /// <summary>
        /// Gets the admission cost information asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <param name="isProviderCost">if set to <c>true</c> [is provider cost].</param>
        /// <returns></returns>
        Task<Admission.BasicViewModel> GetAdmissionCostInfoAsync(FilterModel model, bool isProviderCost);
        /// <summary>
        /// Fetches the pharmacy asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PharmacyIndent.ViewModel>> FetchPharmacyAsync(FilterModel model);

        /// <summary>
        /// Gets the total paid asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<double> GetTotalPaidAsync(FilterModel model);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ViewModel>> FetchAsync(FilterModel model);


        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<SurgeryViewModel>> FetchSurgeryServiceAsync(FilterModel model);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ViewModel>> FindAdmissionAsync(FilterModel model);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<AdmissionNewLabsModel>> FetchLabServicesAsync(FilterModel model);

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<int> InsertAsync(InsertModel model);

        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<(int, List<int?>)> UpdateAsync(UpdateModel model);

        /// <summary>
        /// Gets the admission basic asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<Admission.ViewModel> GetAdmissionBasicAsync(FilterModel model);

        /// <summary>
        /// The fetch Patient details model.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>
        /// </returns>
        Task<string> FetchPatientNameAsync(IdModel model);

        /// <summary>
        /// Fetches the packages asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PackageModuleModel>> FetchPreviousPackagesAsync(StringIdRequest model);

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<int> InsertSurgeryServiceAsync(InsertModel model);

        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<ScanViewModel>> FetchScanServiceAsync(FilterModel model);

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <returns></returns>
        Task<int> InsertScanServiceAsync(InsertModel model);
    }
}
