﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The account credential.
    /// </summary>
    public class DashboardConfigMaster
    {
        /// <summary>
        /// Gets or sets the account credential id.
        /// </summary>
        [Key, Identity]
        public int DashboardConfigMasterId { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public int? RoleId { get; set; }
    }
}
