﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Hims.Shared.Dapper.Attributes;


    public class DoctorUnitMaster
    {
        /// <summary>
        /// Gets or sets the tag doctor  identifier.
        /// </summary>
        /// <value>
        /// The tag doctor identifier.
        /// </value>
        [Key, Identity]
        public int DoctorUnitMasterId { get; set; }

        /// <summary>
        /// Gets or sets doctor.
        /// </summary>
        /// <value>
        /// The name of doctor.
        /// </value>
        public string UnitName { get; set; }
        /// <summary>
        /// Gets or sets designation
        /// </summary>
        /// <value>
        ///  the name of designation
        /// </value>
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>

        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>

        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the locationId.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public int? LocationId { get; set; }
        
        /// <summary>
        /// Gets or sets active.
        /// </summary>
        /// <value>
        /// The active.
        /// </value>
        public bool? Active { get; set; }
       
        
    }
}
