﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities
{
    public class IvfEncounter
    {
        /// <summary>
        /// Gets or Sets the ivf Encounter
        /// </summary>
        [Key, Identity]
        public int IvfEncounterId { get; set; }
        /// <summary>
        /// Gets or Sets the appointment id
        /// </summary>
        public int? AppointmentId { get; set; }
        /// <summary>
        /// Gets or Sets the ivf encounter date
        /// </summary>
        public DateTime IvfEncounterDate { get; set; }
        /// <summary>
        /// Gets or Sets the active
        /// </summary>
        public bool Active { get; set; }
        /// <summary>
        /// Gets or Sets the created by
        /// </summary>
        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or Sets the created date
        /// </summary>
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or Sets the modified by
        /// </summary>
        public int? ModifiedBy { get; set; }
        /// <summary>
        /// Gets or Sets the modified date
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or Sets the admission id
        /// </summary>
        public int? AdmissionId { get; set; }
        /// <summary>
        /// Gets or Sets the gyn history
        /// </summary>
        public string GynHistory { get; set; }
        /// <summary>
        /// Gets or Sets the gyn iui
        /// </summary>
        public string GynIUI { get; set; }
        /// <summary>
        /// Gets or Sets the menstrual history
        /// </summary>
        public string MensutralHistory { get; set; }
        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>

        public string BirthControl { get; set; }
        /// <summary>
        /// Gets or Sets the embryo freezing
        /// </summary>

        public string EmbryoFreezing { get; set; }
        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>
        public string InfertilityHistory { get; set; }
        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>
        public string MarriedLifeHistory { get; set; }
        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>
        public string ContraceptionHistory { get; set; }
        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>
        public string MenstrualHistoryPresent { get; set; }
        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>
        public string AddIUIData { get; set; }
        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>
        public string DualTriggerInjection { get; set; }
        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>
        public string IUIStimulationScan { get; set; }
        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>
        public string IUISummary { get; set; }
        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>
        public string Laproscopy { get; set; }
        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>
        public string Hysteroscopy { get; set; }

        
        /// <summary>
        /// Gets or Sets the CoitalHistory
        /// </summary>

        public string CoitalHistory { get; set; }
        /// <summary>
        /// Gets or Sets the PreviousObstetricHistory
        /// </summary>

        public string PreviousObstetricHistory { get; set; }
        /// <summary>
        /// Gets or Sets the PreviousInfertilityTreatmentHistory
        /// </summary>

        public string PreviousInfertilityTreatmentHistory { get; set; }
        /// <summary>
        /// Gets or Sets the PreviousObstetricHistory
        /// </summary>

        public string MedicalAndSurgicalHistory { get; set; }

      
        public string IvfData { get; set; }
        /// <summary>
        /// Gets or Sets the SingleTriggerInjection
        /// </summary>

        public string SingleTriggerInjection { get; set; }
        /// <summary>
        /// Gets or Sets the DoubleTriggerInjection
        /// </summary>

        public string IvfDualTriggerInjection { get; set; }
        /// <summary>
        /// Gets or Sets the fet
        /// </summary>
        public string Fet { get; set; }
        /// <summary>
        /// Gets or Sets the IvfSimulationScan
        /// </summary>

        public string IvfSimulationScan { get; set; }
        /// <summary>
        /// Gets or Sets the IvfSummary
        /// </summary>

        public string OtherInvestigationHistory { get; set; }
        /// <summary>
        /// Gets or Sets the IvfSummary
        /// </summary>

        public string PersonalHistory { get; set; }
        /// <summary>
        /// Gets or Sets the IvfSummary
        /// </summary>

        public string FamilyHistory { get; set; }
        /// <summary>
        /// Gets or Sets the IvfSummary
        /// </summary>

        public string PhysicalGyecologicalHistory { get; set; }
        /// <summary>
        /// Gets or Sets the embryo thawing
        /// </summary>
        public string EmbryoThawing { get; set; }
        /// <summary>
        /// Gets or Sets the aspiration
        /// </summary>
        public string Aspiration { get; set; }
        /// <summary>
        /// Gets or Sets the cryo preservation
        /// </summary>
        public string CryoPreservation { get; set; }
        /// <summary>
        /// Gets or Sets the oocyte cryo preservation
        /// </summary>
        public string OocytCryoPreservation { get; set; }
        /// <summary>
        /// Gets or Sets the embryology detail
        /// </summary>
        public string EmbyologyDetail { get; set; }

        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>
        public string Fertilization{ get; set; }
        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>
        public string EmbryoQuality { get; set; }
        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>
        public string StimulationChart { get; set; }
        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>
        public string ObservationInfertility { get; set; }
        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>
        public string IvfSummary { get; set; }
        /// <summary>
        /// Gets or Sets the birth control
        /// </summary>
        public string OrdersPrescription { get; set; }
        
    }

}
