﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class LabPackageDetail
    {
        /// <summary>
        /// Gets or sets lab package detail id.
        /// </summary>
        [Key, Identity]
        public int LabPackageDetailId { get; set; }

        /// <summary>
        /// Gets or sets the coupon id.
        /// </summary>
        public int LabPackageId { get; set; }

        /// <summary>
        /// Gets or sets the lab header id. 
        /// </summary>
        public int LabHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }
    }
}
