﻿namespace Hims.Domain.Entities.Labs
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The lab template observed value.
    /// </summary>
    public class LabTemplateObservedValue
    {
        /// <summary>
        /// Gets or sets the lab template observed value identifier.
        /// </summary>
        /// <value>
        /// The lab template observed value identifier.
        /// </value>
        [Key, Identity]
        public long LabTemplateObservedValueId { get; set; }

        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int NewLabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab main detail identifier.
        /// </summary>
        /// <value>
        /// The lab main detail identifier.
        /// </value>
        public int LabMainDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab template header identifier.
        /// </summary>
        /// <value>
        /// The lab template header identifier.
        /// </value>
        public int LabTemplateHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the method text.
        /// </summary>
        /// <value>
        /// The method text.
        /// </value>
        public string MethodText { get; set; }

        /// <summary>
        /// Gets or sets the interpretation text.
        /// </summary>
        /// <value>
        /// The interpretation text.
        /// </value>
        public string InterpretationText { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="LabTemplateObservedValue"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }
    }
}
