﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The telemedicine domain.
    /// </summary>
    public class TelemedicineDomain
    {
        /// <summary>
        /// Gets or sets the telemedicine domain id.
        /// </summary>
        [Key, Identity]
        public int TelemedicineDomainId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is authentication required.
        /// </summary>
        public bool IsAuthenticationRequired { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is active.
        /// </summary>
        public bool IsActive { get; set; }

        /// <summary>
        /// Gets or sets the domain.
        /// </summary>
        public string? Domain { get; set; }

        /// <summary>
        /// Gets or sets the date.
        /// </summary>
        public DateTime Date { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int AccountId { get; set; }
    }
}