﻿using Hims.Shared.Dapper.Attributes;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Hims.Domain.Entities.Vendors
{
    /// <summary>
    /// The supplier product detail.
    /// </summary>
    [Table("SupplierProductDetail", Schema = "vendors")]
    public class SupplierProductDetail
    {
        /// <summary>
        /// Gets or sets the supplier product detail identifier.
        /// </summary>
        /// <value>
        /// The supplier product detail identifier.
        /// </value>
        [Key, Identity]
        public int SupplierProductDetailId { get; set; }

        /// <summary>
        /// Gets or sets the supplier product header identifier.
        /// </summary>
        /// <value>
        /// The supplier product header identifier.
        /// </value>
        public int SupplierProductHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        /// <value>
        /// The purchase rate.
        /// </value>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the MRP.
        /// </summary>
        /// <value>
        /// The MRP.
        /// </value>
        public double Mrp { get; set; }
    }
}
