﻿namespace Hims.Domain.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels.Scan.BookAppointment;
    using Hims.Shared.UserModels.Scan.ScanAppointment;
    using Shared.EntityModels;
    using Shared.UserModels;

    /// <summary>
    /// The id proof Service interface.
    /// </summary>
    public interface IBookScanAppointmentService
    {
        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(InsertBookScanAppointment model);

        /// <summary>
        /// Update of Patient appointment Payment and patient details.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <param name="request">The model.</param>
        /// <returns></returns>
        Task<int> UpdatePatientDetailsPaymentAsync(InsertBookScanAppointment model, ModifyPatientDetails request);

        /// <summary>
        /// fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<FetchBookScanAppointment>> FetchAsync(FilterModel model);

        /// <summary>
        /// reschedule the appointment.
        /// </summary>
        /// <param name="bookScanAppointmentId">The model.</param>
        /// <param name="modifiedBy">Modified By Name.</param>
        /// <param name="appointmentDate">Appointment Date.</param>
        /// <param name="appointmentTime">Appointment Start Time.</param>
        /// <param name="appointmentEndTime">Appointment End Time.</param>
        /// <returns></returns>
        Task<int> RescheduleAsync(int bookScanAppointmentId, int modifiedBy, DateTime appointmentDate, TimeSpan appointmentTime, TimeSpan appointmentEndTime, int scanMachineMasterId);

        /// <summary>
        /// Bulk reschedule the scan appointmenta.
        /// </summary>
        /// <param name="model">The RescheduleScanAppointmentRequest model.</param>
        /// <returns></returns>
        Task<int> BulkRescheduleAsync(RescheduleScanAppointmentRequest model);

        /// <summary>
        /// update the appointment.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateDetailsAsync(InsertBookScanAppointment model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="BookScanAppointmentId">
        /// The filter model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<RescheduleScanAppointmentDetails> FetchScanAppointmentDetails(int BookScanAppointmentId);

        /// <summary>
        /// The update async.
        /// </summary>
        /// /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CancelAsync(InsertBookScanAppointment model);

        /// <summary>
        /// The cancel async.
        /// </summary>
        /// <param name="appointmentIds">The scan appointmentIds.</param>
        /// <param name="reason">The cancel reason.</param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CancelAllAsync(string appointmentIds, string reason);

        /// <summary>
        /// fetches event the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<FetchBookScanAppointment>> FetchFilterEvent(FilterModel model);

        /// <summary>
        /// fetches event the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<FetchBookScanAppointment>> FetchFilterEventPatients(FilterModel model);

        /// <summary>
        /// fetches event the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<FetchBookScanAppointment>> FetchScanReport(FetchBookScanAppointment model);

        /// <summary>
        /// fetches Patient Future Appointment asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<FetchPatientFutureAppointment>> FetchPatientFutureAppointments(FetchPatientFutureAppointment model);

        /// <summary>
        /// fetches scan scroll reports.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<FetchBookScanAppointment>> FetchScanScroll(FetchBookScanAppointment model);

        /// <summary>
        /// fetches pndt reports.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<FetchBookScanAppointment>> FetchPndtReportAsync(FetchBookScanAppointment model);

        /// <summary>
        /// fetches event the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<FetchBookScanAppointment>> FetchScanOutPatients(FetchBookScanAppointment model);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<int>> AddScanDocumentAsync(IEnumerable<ScanDocumentModel> model);

        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="BookScanAppointmentId">
        /// The filter model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ScanDocumentModel>> FetchScanDocumentAsync(int BookScanAppointmentId);


        Task<IEnumerable<ScanDocumentModel>> FetchPacsImagesAsync(int patientId);
    }
}
