﻿using Hims.Domain.Entities;
using Hims.Shared.EntityModels;
using Hims.Shared.Library;
using Hims.Shared.UserModels.Common;
using Hims.Shared.UserModels.PackageModule;
using System;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace Hims.Domain.Services
{
    public interface IPackageModuleService
    {
        Task<decimal> GetCounsellingTotalAsync(int counsellingId);

        Task<IEnumerable<PackageModuleDetail>> FetchPackageDetails(StringIdRequest model);

        Task<IEnumerable<Resource>> FetchLocationsAsync();

        Task<IEnumerable<ModuleModel>> FetchModulesAsync(int chargeModuleTemplateId);

        Task<IEnumerable<ModuleChargeModel>> FetchModuleChargesAsync(string modulesMasterIds, int locationId);

        Task<IEnumerable<Resource>> FetchChargeCategoriesAsync(int chargeModuleTemplateId);

        Task<IEnumerable<Resource>> FetchChargeCategoriesWithTotalAsync(int packageModuleId, int chargeModuleTemplateId, int locationId);

        Task<IEnumerable<ChargeModuleDetailsModel>> FetchChargeModuleDetailsAsync(ChargeModuleDetailsRequestModel request);

        Task<IEnumerable<PackageModuleModel>> FetchAsync(PackageModuleFilterModel model);

        Task<PackageModuleViewModel> ViewAsync(int packageModuleId);

        Task<int> AddAsync(PackageModuleModel model, List<PackageModuleDetailModel> packageModuleDetails);

        Task<int> UpdateAsync(PackageModuleModel model, List<PackageModuleDetailModel> packageModuleDetails);

        Task<int> DeleteAsync(int packageModuleId);

        Task<int> DisableAsync(int packageModuleId, int createdBy);

        Task<int> EnableAsync(int packageModuleId, int createdBy);

        Task<Tuple<decimal, string, decimal>> GetChargeCategoryTotalAsync(int chargeCategoryId, int packageModuleId, int locationId, int chargeModuleTemplateId, string modulesMasterIds);
       
        Task<IEnumerable<int>> AddPackageDocumentAsync(IEnumerable<PackageDocumentModel> model);
       
        Task<IEnumerable<PackageDocumentModel>> FetchPackageDocuments(int PackageModuleId);
    }
}