﻿namespace Hims.Domain.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels;
    using Shared.EntityModels;

    /// <summary>
    /// The Service Service interface.
    /// </summary>
    public interface ITicketService
    {
        /// <summary>
        /// The check account exists.
        /// </summary>
        /// <param name="mobile">
        /// The mobile.
        /// </param>
        /// <param name="roleId">
        /// The role id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<AccountModel> CheckAccountExists(string mobile, int roleId);

        /// <summary>
        /// The get support categories.
        /// </summary>
        /// <param name="isExists">
        /// The is exists.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<SupportCategories>> GetSupportCategories(bool? isExists);

        /// <summary>
        /// The generate ticket async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<Tuple<int, string>> GenerateTicketAsync(TicketModel model);

        /// <summary>
        /// The create ticket timeline.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> CreateTicketTimeline(TicketTimelineModel model);

        /// <summary>
        /// The fetch all ticket async.
        /// </summary>
        /// <param name="pageSize">
        /// The page size.
        /// </param>
        /// <param name="pageIndex">
        /// The page index.
        /// </param>
        /// <param name="assignedTo">
        /// The assigned to.
        /// </param>
        /// <param name="isAdmin">
        /// The is admin.
        /// </param>
        /// <param name="accountId">
        /// The account id.
        /// </param>
        /// <param name="priority">
        /// The priority.
        /// </param>
        /// <param name="status">
        /// The status.
        /// </param>
        /// <param name="startDate">
        /// The start date.
        /// </param>
        /// <param name="endDate">
        /// The end date.
        /// </param>
        /// <param name="issueWith">
        /// The issue with.
        /// </param>
        /// <param name="mobileNo"></param>
        /// <param name="deviceType"></param>
        /// <param name="assigneeAccountId"></param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<TicketModel>> FetchAllTicketAsync(int pageSize, int pageIndex, int? assignedTo, bool? isAdmin, int? accountId, string priority, string status, DateTime? startDate, DateTime? endDate, string issueWith, string mobileNo, string deviceType, int? assigneeAccountId,int? locationId);

        /// <summary>
        /// The get ticket details.
        /// </summary>
        /// <param name="ticketId">
        /// The encrypted ticket id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<TicketDetailsModel> GetTicketDetails(long ticketId);

        /// <summary>
        /// The get count.
        /// </summary>
        /// <param name="accountId">
        /// The account Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<TicketCountModel> GetCount(int? accountId);

        /// <summary>
        /// The modify ticket.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ModifyTicket(TicketDetailsModel model);

        /// <summary>
        /// The fetch ticket time line async.
        /// </summary>
        /// <param name="ticketId">
        /// The ticket id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<TicketTimelineModel>> FetchTicketTimeLineAsync(long ticketId);

        /// <summary>
        /// The update ticket comments async.
        /// </summary>
        /// <param name="ticketTimelineId">
        /// The ticket id.
        /// </param>
        /// <param name="comments">
        /// The comments.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateTicketCommentsAsync(long ticketTimelineId, string comments);

        /// <summary>
        /// The add ticket owner async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddTicketOwnerAsync(TicketAssigneeModel model);

        /// <summary>
        /// The update ticket timeline.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateTicketTimeline(TicketTimelineModel model);

        /// <summary>
        /// The fetch performance time.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<PerformanceModel> FetchPerformanceTime();

        /// <summary>
        /// The get tickets async.
        /// </summary>
        /// <param name="starDate">
        /// The star date.
        /// </param>
        /// <param name="type">
        /// The end date.
        /// </param>
        /// <param name="accountId">
        /// The account id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<TicketModel>> GetTicketsAsync(DateTime? starDate, string type, int? accountId);

        /// <summary>
        /// The get support users async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<AccountModel>> GetSupportUsersAsync(string mobile);

        /// <summary>
        /// The add ticket owner async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateTicketOwnerAsync(TicketAssigneeModel model);

    }
}
