﻿namespace Hims.Infrastructure.Configurations
{
    using Domain.Configurations;

    /// <inheritdoc />
    public class PayUConfiguration : IPayUConfiguration
    {
        /// <inheritdoc />
        public string PaymentURL { get; set; }

        /// <inheritdoc />
        public string Key { get; set; }

        /// <inheritdoc />
        public string Salt { get; set; }

        /// <inheritdoc />
        public string ServiceProvider { get; set; }

        /// <inheritdoc />
        public string SuccessLink { get; set; }

        /// <inheritdoc />
        public string FailureLink { get; set; }

        /// <inheritdoc />
        public string RedirectSuccessLink { get; set; }

        /// <inheritdoc />
        public string RedirectFailureLink { get; set; }

        /// <inheritdoc />
        public string AuthHeader { get; set; }

        /// <inheritdoc />
        public string PayUUrl { get; set; }

        /// <inheritdoc />
        public string PayoutOauthURL { get; set; }

        /// <inheritdoc />
        public string ClientId { get; set; }

        /// <inheritdoc />
        public string PayoutMerchantId { get; set; }

        /// <inheritdoc />
        public string WebHooks { get; set; }

        /// <summary>
        /// Gets or sets the authorization key.
        /// </summary>
        public string AuthorizationKey { get; set; }
    }
}
