﻿#nullable enable
using Hims.Shared.Dapper.Attributes;
using System;
using System.ComponentModel.DataAnnotations;

namespace Hims.Domain.Entities
{
    /// <summary>
    /// The lookup.
    /// </summary>
    public class NurseShiftBedMap
    {
        /// <summary>
        /// Gets or sets the nurse shift map id.
        /// </summary>
        [Key, Identity]
        public int NurseShiftBedMapId { get; set; }

        /// <summary>
        /// Gets or sets the bed ids.
        /// </summary>
        public int NurseShiftMapId { get; set; }

        /// <summary>
        /// Gets or sets the bed ids.
        /// </summary>
        public int BedId { get; set; }

        /// <summary>
        /// Gets or sets the crdeated by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
    }
}