﻿namespace Hims.Domain.Entities
{
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The payment status.
    /// </summary>
    public class PayType
    {
        /// <summary>
        /// Gets or sets the payment status id.
        /// </summary>
        [Key, Identity]
        public int PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string PayTypeName { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool IsActive { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string PayTypeValue { get; set; }
        /// <summary>
        /// Gets or sets the status of Salucro.
        /// </summary>
        public bool SalucroPayType { get; set; }
    }
}
