﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The provider location.
    /// </summary>
    public class ProviderLocationModel
    {
        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the practice location name.
        /// </summary>
        public string PracticeLocationName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the practice id.
        /// </summary>
        public int PracticeId { get; set; }

        /// <summary>
        /// Gets or sets the practice name.
        /// </summary>
        public string PracticeName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the practice TIN.
        /// </summary>
        public string PracticeTIN { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the currency symbol.
        /// </summary>
        public char CurrencySymbol { get; set; }

        /// <summary>
        /// Gets or sets the consultation duration.
        /// </summary>
        public short? ConsultationDuration { get; set; }

        /// <summary>
        /// Gets or sets the consultation charges.
        /// </summary>
        public decimal? ConsultationCharges { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine duration.
        /// </summary>
        public short? TelemedicineDuration { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine charges.
        /// </summary>
        public decimal? TelemedicineCharges { get; set; }

        /// <summary>
        /// Gets or sets the in patient duration.
        /// </summary>
        public short? InPatientDuration { get; set; }

        /// <summary>
        /// Gets or sets the out patient duration.
        /// </summary>
        public short? OutPatientDuration { get; set; }

        /// <summary>
        /// Gets or sets the casualty duration.
        /// </summary>
        public short? CasualtyDuration { get; set; }

        /// <summary>
        /// Gets or sets the follow up days.
        /// </summary>
        public short? FollowUpDays { get; set; }

        /// <summary>
        /// Gets or sets the available days.
        /// </summary>
        public string AvailableDays { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the Availability.
        /// </summary>
        public string Availability { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is fallow up.
        /// </summary>
        public bool IsFallowUp { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the  comments.
        /// </summary>
        public string? FullName { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the  comments.
        /// </summary>
        public int? RoleId { get; set; }

        /// <summary>
        /// Gets or sets the follow up days for ip.
        /// </summary>
        public short? FollowUpDaysForIp { get; set; }


        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        public string Duration { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the provider location operation.
        /// </summary>
        /// <value>
        /// The provider location operation id.
        /// </value>
        public int ProviderLocationOperationId { get; set; }

        /// <summary>
        /// Gets or sets the is telemedicine.
        /// </summary>
        public bool IsTelemedicine { get; set; }

        /// <summary>
        /// Gets or sets the is online consultation.
        /// </summary>
        public bool IsOnlineConsultation { get; set; }
    }
}
