﻿#nullable enable
namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The appointment transaction filter model.
    /// </summary>
    public class AppointmentTransactionFilterModel
    {
        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the Visit type.
        /// </summary>
        public string? VisitType { get; set; }

        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string? FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string? ToDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string? AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string? TransactionId { get; set; }

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int PageSize { get; set; }
        
        /// <summary>
        /// Gets or sets the payment id.
        /// </summary>
        public int PaymentId { get; set; }

        /// <summary>
        /// Gets or sets the year.
        /// </summary>
        public string? Year { get; set; }

        /// <summary>
        /// Gets or sets the month.
        /// </summary>
        public string? Month { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string? ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the patient country id.
        /// </summary>
        public int? PatientCountryId { get; set; }

        /// <summary>
        /// Gets or sets the file name.
        /// </summary>
        public string FileName { get; set; } = string.Empty;
    }
}
