﻿using Hims.Shared.Library.Enums;
using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.Filters
{
    /// <summary>
    /// The encounter filter model.
    /// </summary>
    public class IvfEncouterFilterModel
    {
        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int IvfEncouterId { get; set; }

        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted encounter id.
        /// </summary>
        public string? EncryptedEncounterId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string? EncryptedAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string? EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string? EncryptedProviderId { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public IvfEncounterType Type { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        public bool IsAdmission { get; set; }

       
    }
}
