﻿namespace Hims.Shared.UserModels.Menu.Access
{
    /// <summary> The chat.</summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the menu access identifier.
        /// </summary>
        /// <value>
        /// The menu access identifier.
        /// </value>
        public int MenuAccessId { get; set; }

        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is full access.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is full access; otherwise, <c>false</c>.
        /// </value>
        public bool IsFullAccess { get; set; }

        /// <summary>
        /// Gets or sets the initial route menu identifier.
        /// </summary>
        /// <value>
        /// The initial route menu identifier.
        /// </value>
        public int? InitialRouteMenuId { get; set; }

        /// <summary>
        /// Gets or sets the URL.
        /// </summary>
        /// <value>
        /// The URL.
        /// </value>
        public string Url { get; set; }

        /// <summary>
        /// Gets or sets the main page.
        /// </summary>
        /// <value>
        /// The main page.
        /// </value>
        public string MainPage { get; set; }

        /// <summary>
        /// Gets or sets the sub page.
        /// </summary>
        /// <value>
        /// The sub page.
        /// </value>
        public string SubPage { get; set; }
    }
}