﻿namespace Hims.Shared.UserModels.ProgressReport.Diet
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The insert model.
    /// </summary>
    public class InsertModel
    {
        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the vital type value.
        /// </summary>
        public int? MealTypeId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? modifiedBy { get; set; }
        

        /// <summary>
        /// Gets or sets the records.
        /// </summary>
        /// <value>
        /// The records.
        /// </value>
        public List<InsertModelHelper> Records { get; set; }

    }

    /// <summary>
    /// The receipt model
    /// </summary>
    public class InsertModelHelper
    {
        
        /// <summary>
        /// Gets or sets the duration.
        /// </summary>
        /// <value>
        /// The duration.
        /// </value>
        public int Duration { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        /// <value>
        /// The start date.
        /// </value>
        public DateTime StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        /// <value>
        /// The end date.
        /// </value>
        public DateTime EndDate { get; set; }

        /// <summary>
        /// Gets or sets the medication duration type identifier.
        /// </summary>
        /// <value>
        /// The medication duration type identifier.
        /// </value>
        public int MedicationDurationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the meal type id.
        /// </summary>
        public int? MealTypeId { get; set; }

        /// <summary>
        /// Gets or sets the meal type id.
        /// </summary>
        public string DietInstructions { get; set; }
        
        /// <summary>
        /// Gets or sets the is morning.
        /// </summary>
        public bool IsMorning { get; set; }
        
        /// <summary>
        /// Gets or sets the is afternoon.
        /// </summary>
        public bool IsAfternoon { get; set; }
        
        /// <summary>
        /// Gets or sets the is night.
        /// </summary>
        public bool IsNight { get; set; }
    }

}
