﻿using Hims.Shared.Dapper.Attributes;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Domain.Entities
{
    public class BirthCertificate
    {
        /// <summary>
        /// Gets or sets the birth certificate id.
        /// </summary>
        [Key, Identity]
        public int BirthCertificateId { get; set; }

        /// <summary>
        /// Gets or sets the birth certificate no.
        /// </summary>
        public string BirthCertificateNo { get; set; }

        /// <summary>
        /// Gets or sets the child name.
        /// </summary>
        public string ChildName { get; set; }
        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        public DateTime? DateOfBirth { get; set; }
        /// <summary>
        /// Gets or sets the time of birth.
        /// </summary>
        public string TimeOfBirth { get; set; }
        /// <summary>
        /// Gets or sets the sex.
        /// </summary>
        public string Sex { get; set; }
        /// <summary>
        /// Gets or sets the place of birth.
        /// </summary>
        public string PlaceOfBirth { set; get; }
        /// <summary>
        /// Gets or sets the age of mother before marriage.
        /// </summary>
        public int? AgeOfMotherAtMarriage { get; set; }
        /// <summary>
        /// Gets or sets the informants name.
        /// </summary>
        public string InformantsName { get; set; }
        /// <summary>
        /// Gets or sets the informants address.
        /// </summary>
        public string InformantsAddress { get; set; }
        /// <summary>
        /// Gets or sets the patientId.
        /// </summary>
        public int PatientId { get; set; }
        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int AdmissionId { get; set; }
        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
        public int? BabyWeight { get; set; }
        public string TypeOfDelivery { get; set; }
        public string MethodOfDelivery { get; set; }
        public string DurationOfPregnancy { get; set; }
        public string NoOfChildBorn { get; set; }
    }
}
