﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The dental encounter.
    /// </summary>
    public class DentalEncounter
    {
        /// <summary>
        /// Gets or sets the dental encounter id.
        /// </summary>
        [Key, Identity]
        public int DentalEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        [IgnoreUpdate]
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the dental encounter date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime DentalEncounterDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the medical history.
        /// </summary>
        public string? MedicalHistory { get; set; }

        /// <summary>
        /// Gets or sets the dental history.
        /// </summary>
        public string? DentalHistory { get; set; }

        /// <summary>
        /// Gets or sets the family history.
        /// </summary>
        public string? FamilyHistory { get; set; }

        /// <summary>
        /// Gets or sets the oral hygiene.
        /// </summary>
        public string? OralHygiene { get; set; }

        /// <summary>
        /// Gets or sets the clinical findings.
        /// </summary>
        public string? ClinicalFindings { get; set; }

        /// <summary>
        /// Gets or sets the diagnosis.
        /// </summary>
        public string? Diagnosis { get; set; }

        /// <summary>
        /// Gets or sets the medications.
        /// </summary>
        public string? Medications { get; set; }

        /// <summary>
        /// Gets or sets the personal habits.
        /// </summary>
        public string? PersonalHabits { get; set; }

        /// <summary>
        /// Gets or sets the chief complaints.
        /// </summary>
        public string? ChiefComplaints { get; set; }

        /// <summary>
        /// Gets or sets the medication comment.
        /// </summary>
        public string? MedicationComment { get; set; }
    }
}
