﻿namespace Hims.Domain.Entities.Labs
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The lab template header.
    /// </summary>
    public class LabTemplateHeader
    {
        /// <summary>
        /// Gets or sets the lab template header identifier.
        /// </summary>
        /// <value>
        /// The lab template header identifier.
        /// </value>
        [Key,Identity]
        public int LabTemplateHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the name of the template.
        /// </summary>
        /// <value>
        /// The name of the template.
        /// </value>
        public string TemplateName { get; set; }

        /// <summary>
        /// Gets or sets the template identifier.
        /// </summary>
        /// <value>
        /// The template identifier.
        /// </value>
        public string TemplateId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="LabTemplateHeader"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is method.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is method; otherwise, <c>false</c>.
        /// </value>
        public bool IsMethod { get; set; }

        /// <summary>
        /// Gets or sets the method text.
        /// </summary>
        /// <value>
        /// The method text.
        /// </value>
        public string MethodText { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is interpretation.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is interpretation; otherwise, <c>false</c>.
        /// </value>
        public bool IsInterpretation { get; set; }

        /// <summary>
        /// Gets or sets the interpretation text.
        /// </summary>
        /// <value>
        /// The interpretation text.
        /// </value>
        public string InterpretationText { get; set; }
    }
}
