﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The Specialization.
    /// </summary>
    public class Specialization
    {
        /// <summary>
        /// Gets or sets the Specialization id.
        /// </summary>
        [Key, Identity]
        public int SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the SpecializationIcon id.
        /// </summary>

        public int? SpecializationIconId { get; set; }
        /// <summary>
        /// Gets or sets the Specialization name.
        /// </summary>
        public string SpecializationName { get; set; }

        /// <summary>
        /// Gets or sets the specialization description.
        /// </summary>
        public string SpecializationDescription { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        public int? Priority { get; set; }

        /// <summary>
        /// Gets or sets the encounter type id.
        /// </summary>
        public int? EncounterTypeId {get; set;}
    }
}
