﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Shared.UserModels;
    using Hims.Shared.UserModels.Common;
    using Hims.Shared.UserModels.DashboardWidget;
    using Shared.EntityModels;

    /// <summary>
    /// The Appointment Service interface.
    /// </summary>
    public interface IDashboardWidgetService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<DashboardWidgetModel>> FetchAsync(DashboardWidgetFilterModel model);

        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<GenericResponse> InsertAsync(DashboardWidgetModel model);

        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<GenericResponse> UpdateAsync(DashboardWidgetModel model);

        /// <summary>
        /// The fetch widget.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<string> FetchWidgetType(int dashboardWidgetTypeId);

        /// <summary>
        /// Deactivates the widget asynchronous.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeactivateWidget(int id, int modifiedBy, string modifiedByName);

        /// <summary>
        /// Deactivates the widget asynchronous.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ActivateWidget(int id, int modifiedBy, string modifiedByName);

        /// <summary>
        /// Executes the count asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<GenericResponse> ExecuteAsync(ExecuteInputModel model);
    }
}
