﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;

    /// <summary>
    /// The Coupon Service interface.
    /// </summary>
    public interface IDischargeInstructionService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<DischargeModel>> FetchAsync(DischargeFilterModel model);


        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(DischargeModel model);

        ///// <summary>
        ///// The update async.
        ///// </summary>
        ///// <param name="model">
        ///// The model.
        ///// </param>
        ///// <returns>
        ///// The <see cref="Task"/>.
        ///// </returns>
        //Task<int> UpdateAsync(DischargeModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="dischargeInstructionId">
        /// The coupon id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> DeleteAsync(int dischargeInstructionId);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="model">
        /// The coupon id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(DischargeModel model);

        /// <summary>
        /// The get delete async.
        /// </summary>
        /// <param name="model">
        /// The coupon id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> ModifyStatusAsync(DischargeModel model);

    }
}
