﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;

    using Hims.Shared.UserModels.Filters;

    /// <summary>
    /// The ICDCode Service interface.
    /// </summary>
    public interface IIcdService
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<ICDCodeModel>> FetchAsync(IcdCodeFilterModel model);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> AddAsync(ICDCodeModel model);

        /// <summary>
        /// The update async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> UpdateAsync(ICDCodeModel model);

        /// <summary>The get delete async.</summary>
        /// <param name="icdCodeId">The icd Code Id.</param>
        /// <returns>The <see cref="Task"/>.</returns>
        Task<int> DeleteAsync(int icdCodeId);

        /// <summary>
        /// The get delete async in provider encounter.
        /// </summary>
        /// <param name="icdCodeId">
        /// The generalAdvice id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<int> updateProviderEncounterAsync(int icdCodeId);
    }
}
