﻿namespace Hims.Infrastructure.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;

    using Dapper;

    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Shared.EntityModels;
    using Hims.Shared.UserModels.Filters;

    /// <inheritdoc />
    public class ProviderEncounterServices : IProviderEncounterService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IProviderService" />
        public ProviderEncounterServices(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        /// <inheritdoc />
        public async Task<int> AddAsync(ProviderEncounterModel model)
        {
            var checkIf = await this.unitOfWork.Current.QueryFirstOrDefaultAsync<int>($@"SELECT COUNT(""ProviderGeneralAdviceId"") FROM ""ProviderEncounter"" WHERE ""ProviderId"" = {model.ProviderId}");
            if (checkIf > 0)
            {
                return -1;
            }

            var providerEncounter = new ProviderEncounter
            {
                ProviderId = model.ProviderId,
                GeneralAdviceIds = model.GeneralAdviceIds,
                ICDIds = model.IcdIds,
                CreatedDate = DateTime.UtcNow,
                LabOrderValueIds = model.LabOrderValueIds,
                CreatedBy = model.CreatedBy,
                RadiologyValueIds = model.RadiologyValueIds,
                AllergyIds = model.AllergyIds,
                ReactionIds = model.ReactionIds,
                HospitalizationIds = model.HospitalizationIds,
                InitialIds = model.InitialIds,
                PCareIds = model.PCareIds,
                SiteIds = model.SiteIds,
                VaccineIds = model.VaccineIds
            };
            return await this.unitOfWork.ProviderEncounters.InsertAsync(providerEncounter);
        }

        /// <inheritdoc />
        public async Task<int> UpdateAsync(ProviderEncounterModel model)
        {
            if (!string.IsNullOrEmpty(model.GeneralAdviceIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""GeneralAdviceIds"" = '{ model.GeneralAdviceIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId"" = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId} ";
                await this.unitOfWork.Current.ExecuteAsync(query);
                return 1;
            }

            if (!string.IsNullOrEmpty(model.IcdIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET  ""ICDIds"" = '{ model.IcdIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId"" = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                await this.unitOfWork.Current.ExecuteAsync(query);
                return 2;
            }

            if (!string.IsNullOrEmpty(model.LabOrderValueIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET  ""LabOrderValueIds"" = '{ model.LabOrderValueIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                await this.unitOfWork.Current.ExecuteAsync(query);
                return 3;
            }

            if (!string.IsNullOrEmpty(model.RadiologyValueIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""RadiologyValueIds"" = '{ model.RadiologyValueIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                await this.unitOfWork.Current.ExecuteAsync(query);
                return 4;
            }

            if (!string.IsNullOrEmpty(model.AllergyIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""AllergyIds"" = '{ model.AllergyIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                await this.unitOfWork.Current.ExecuteAsync(query);
                return 5;
            }

            if (!string.IsNullOrEmpty(model.ReactionIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""ReactionIds"" = '{ model.ReactionIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                await this.unitOfWork.Current.ExecuteAsync(query);
                return 6;
            }

            if (!string.IsNullOrEmpty(model.HospitalizationIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""HospitalizationIds"" = '{ model.HospitalizationIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                await this.unitOfWork.Current.ExecuteAsync(query);
                return 7;
            }

            if (!string.IsNullOrEmpty(model.InitialIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""InitialIds"" = '{ model.InitialIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                await this.unitOfWork.Current.ExecuteAsync(query);
                return 8;
            }

            if (!string.IsNullOrEmpty(model.PCareIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""PCareIds"" = '{ model.PCareIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                await this.unitOfWork.Current.ExecuteAsync(query);
                return 9;
            }

            if (!string.IsNullOrEmpty(model.SiteIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""SiteIds"" = '{ model.SiteIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                await this.unitOfWork.Current.ExecuteAsync(query);
                return 10;
            }

            if (!string.IsNullOrEmpty(model.VaccineIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""VaccineIds"" = '{ model.VaccineIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                await this.unitOfWork.Current.ExecuteAsync(query);
                return 11;
            }

            return 0;
        }

        /// <inheritdoc />
        public async Task<int> UnAssignAllGeneralAdvicesAsync(ProviderEncounterModel model)
        {
            if (string.IsNullOrEmpty(model.GeneralAdviceIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""GeneralAdviceIds"" = '{ model.GeneralAdviceIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId"" = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId} ";
                return await this.unitOfWork.Current.ExecuteAsync(query);
            }

            return 0;
        }

        /// <inheritdoc />
        public async Task<int> UnAssignAllIcdCodeAsync(ProviderEncounterModel model)
        {
            if (string.IsNullOrEmpty(model.IcdIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET  ""ICDIds"" = '{ model.IcdIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId"" = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                return await this.unitOfWork.Current.ExecuteAsync(query);
            }

            return 0;
        }

        /// <inheritdoc />
        public async Task<int> UnAssignAllLabOrderValueAsync(ProviderEncounterModel model)
        {
            if (string.IsNullOrEmpty(model.LabOrderValueIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET  ""LabOrderValueIds"" = '{ model.LabOrderValueIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                return await this.unitOfWork.Current.ExecuteAsync(query);
            }

            return 0;
        }

        /// <inheritdoc />
        public async Task<int> UnAssignAllRadiologyValueAsync(ProviderEncounterModel model)
        {
            if (string.IsNullOrEmpty(model.RadiologyValueIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""RadiologyValueIds"" = '{ model.RadiologyValueIds }',""CreatedBy"" = {model.CreatedBy}, ""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                return await this.unitOfWork.Current.ExecuteAsync(query);
            }

            return 0;
        }

        /// <inheritdoc />
        public async Task<int> UnAssignAllAllergiesAsync(ProviderEncounterModel model)
        {
            if (string.IsNullOrEmpty(model.AllergyIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""AllergyIds"" = '{ model.AllergyIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                return await this.unitOfWork.Current.ExecuteAsync(query);
            }

            return 0;
        }

        /// <inheritdoc />
        public async Task<int> UnAssignAllReactionsAsync(ProviderEncounterModel model)
        {
            if (string.IsNullOrEmpty(model.ReactionIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""ReactionIds"" = '{ model.ReactionIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                return await this.unitOfWork.Current.ExecuteAsync(query);
            }

            return 0;
        }

        /// <inheritdoc />
        public async Task<int> UnAssignAllHospitalizationAsync(ProviderEncounterModel model)
        {
            if (string.IsNullOrEmpty(model.HospitalizationIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""HospitalizationIds"" = '{ model.HospitalizationIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                return await this.unitOfWork.Current.ExecuteAsync(query);
            }

            return 0;
        }

        /// <inheritdoc />
        public async Task<int> UnAssignAllInitialsAsync(ProviderEncounterModel model)
        {
            if (string.IsNullOrEmpty(model.InitialIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""InitialIds"" = '{ model.InitialIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                return await this.unitOfWork.Current.ExecuteAsync(query);
            }

            return 0;
        }

        /// <inheritdoc />
        public async Task<int> UnAssignAllPCareAsync(ProviderEncounterModel model)
        {
            if (string.IsNullOrEmpty(model.PCareIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""PCareIds"" = '{ model.PCareIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                return await this.unitOfWork.Current.ExecuteAsync(query);
            }

            return 0;
        }

        /// <inheritdoc />
        public async Task<int> UnAssignAllSiteAsync(ProviderEncounterModel model)
        {
            if (string.IsNullOrEmpty(model.SiteIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""SiteIds"" = '{ model.SiteIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                return await this.unitOfWork.Current.ExecuteAsync(query);
            }

            return 0;
        }

        /// <inheritdoc />
        public async Task<int> UnAssignAllVaccineAsync(ProviderEncounterModel model)
        {
            if (string.IsNullOrEmpty(model.VaccineIds))
            {
                var query = $@"UPDATE ""ProviderEncounter"" SET ""VaccineIds"" = '{ model.VaccineIds }',""ModifiedBy"" = {model.ModifiedBy}, ""ModifiedDate"" = NOW() AT TIME ZONE 'UTC' WHERE ""ProviderGeneralAdviceId""  = { model.ProviderGeneralAdviceId} AND ""ProviderId"" = { model.ProviderId}";
                return await this.unitOfWork.Current.ExecuteAsync(query);
            }

            return 0;
        }

        /// <inheritdoc />
        public Task<IEnumerable<ProviderEncounterModel>> FetchAsync(ProviderEncounterFilterModel model)
        {
            var where = " WHERE 1 = 1 ";
            if (!string.IsNullOrEmpty(model.FullName))
            {
                where += $@" AND pr.""FullName"" ILIKE '%{model.FullName}%'";
            }

            var query = $@"SELECT  COUNT(*) OVER () AS ""TotalItems"" ,pre. *,pr. ""FullName"" from  ""ProviderEncounter"" pre INNER JOIN ""Provider"" pr ON pre.""ProviderId"" = pr.""ProviderId"" {where} Order by ""ProviderGeneralAdviceId"" DESC";
            if (model.PageIndex <= 0)
            {
                return this.unitOfWork.Current.QueryAsync<ProviderEncounterModel>(query);
            }

            model.PageIndex -= 1;
            query += " LIMIT " + model.PageSize + " offset " + (model.PageIndex * model.PageSize);
            return this.unitOfWork.Current.QueryAsync<ProviderEncounterModel>(query);
        }

        /// <inheritdoc />
        public ProviderEncounterModel FetchProviderEncounterAsync(int providerId)
        {
            var where = " WHERE 1 = 1";
            var query = $@"SELECT pre. *,pr. ""FullName"" from  ""ProviderEncounter"" pre INNER JOIN ""Provider"" pr ON pre.""ProviderId"" = pr.""ProviderId"" {where} AND pre.""ProviderId"" = { providerId } ";
            var record = this.unitOfWork.Current.QueryFirstOrDefault<ProviderEncounterModel>(query);
            return record;
        }

        /// <inheritdoc />
        public Task<IEnumerable<RadiologyValueModel>> FetchRadiologyValueAsync(RadiologyValueFilterModel model)
        {
            var where = " WHERE 1 = 1 ";
            if (!string.IsNullOrEmpty(model.OrderCode))
            {
                where += $@" AND ""OrderCode"" ILIKE '%{model.OrderCode}%'";
            }

            var query = $@"SELECT COUNT(*) OVER () AS ""TotalItems"", * from  ""RadiologyValue"" {where} Order by ""RadiologyValueId"" DESC";

            if (model.PageIndex <= 0)
            {
                return this.unitOfWork.Current.QueryAsync<RadiologyValueModel>(query);
            }

            model.PageIndex -= 1;
            query += " LIMIT " + model.PageSize + " offset " + (model.PageIndex * model.PageSize);
            return this.unitOfWork.Current.QueryAsync<RadiologyValueModel>(query);
        }

        /// <inheritdoc />
        public Task<IEnumerable<LookupValueModel>> FetchAllergiesAsync(LookUpValueFilterModel model)
        {
            var where = " WHERE 1 = 1 AND";
            if (!string.IsNullOrEmpty(model.Name))
            {
                where += $@" ""Name"" ILIKE '%{model.Name}%' AND";
            }

            var query = $@"SELECT COUNT(*) OVER () AS ""TotalItems"", * from  ""LookupValue"" {where} ""LookupId"" = {9} Order by ""LookupValueId"" DESC ";

            if (model.PageIndex <= 0)
            {
                return this.unitOfWork.Current.QueryAsync<LookupValueModel>(query);
            }

            model.PageIndex -= 1;
            query += " LIMIT " + model.PageSize + " offset " + (model.PageIndex * model.PageSize);
            return this.unitOfWork.Current.QueryAsync<LookupValueModel>(query);
        }

        /// <inheritdoc />
        public Task<IEnumerable<LookupValueModel>> FetchReactionsAsync(LookUpValueFilterModel model)
        {
            var where = " WHERE 1 = 1 AND";
            if (!string.IsNullOrEmpty(model.Name))
            {
                where += $@" ""Name"" ILIKE '%{model.Name}%' AND";
            }

            var query = $@"SELECT COUNT(*) OVER () AS ""TotalItems"", * from  ""LookupValue"" {where} ""LookupId"" = {46} Order by ""LookupValueId"" DESC";

            if (model.PageIndex <= 0)
            {
                return this.unitOfWork.Current.QueryAsync<LookupValueModel>(query);
            }

            model.PageIndex -= 1;
            query += " LIMIT " + model.PageSize + " offset " + (model.PageIndex * model.PageSize);
            return this.unitOfWork.Current.QueryAsync<LookupValueModel>(query);
        }

        /// <inheritdoc />
        public Task<IEnumerable<LookupValueModel>> FetchHospitalizationsAsync(LookUpValueFilterModel model)
        {
            var where = " WHERE 1 = 1 AND";
            if (!string.IsNullOrEmpty(model.Name))
            {
                where += $@" ""Name"" ILIKE '%{model.Name}%' AND";
            }

            var query = $@"SELECT COUNT(*) OVER () AS ""TotalItems"", * from  ""LookupValue"" {where} ""LookupId"" = {10} Order by ""LookupValueId"" DESC";

            if (model.PageIndex <= 0)
            {
                return this.unitOfWork.Current.QueryAsync<LookupValueModel>(query);
            }

            model.PageIndex -= 1;
            query += " LIMIT " + model.PageSize + " offset " + (model.PageIndex * model.PageSize);
            return this.unitOfWork.Current.QueryAsync<LookupValueModel>(query);
        }

        /// <inheritdoc />
        public Task<IEnumerable<LookupValueModel>> FetchInitialsAsync(LookUpValueFilterModel model)
        {
            var where = " WHERE 1 = 1 AND";
            if (!string.IsNullOrEmpty(model.Name))
            {
                where += $@" ""Name"" ILIKE '%{model.Name}%' AND";
            }

            var query = $@"SELECT COUNT(*) OVER () AS ""TotalItems"", * from  ""LookupValue"" {where} ""LookupId"" = {51} Order by ""LookupValueId"" DESC";

            if (model.PageIndex <= 0)
            {
                return this.unitOfWork.Current.QueryAsync<LookupValueModel>(query);
            }

            model.PageIndex -= 1;
            query += " LIMIT " + model.PageSize + " offset " + (model.PageIndex * model.PageSize);
            return this.unitOfWork.Current.QueryAsync<LookupValueModel>(query);
        }

        /// <inheritdoc />
        public Task<IEnumerable<LookupValueModel>> FetchPCaresAsync(LookUpValueFilterModel model)
        {
            var where = " WHERE 1 = 1 AND";
            if (!string.IsNullOrEmpty(model.Name))
            {
                where += $@" ""Name"" ILIKE '%{model.Name}%' AND";
            }

            var query = $@"SELECT COUNT(*) OVER () AS ""TotalItems"", * from  ""LookupValue"" {where} ""LookupId"" = {41} Order by ""LookupValueId"" DESC";

            if (model.PageIndex <= 0)
            {
                return this.unitOfWork.Current.QueryAsync<LookupValueModel>(query);
            }

            model.PageIndex -= 1;
            query += " LIMIT " + model.PageSize + " offset " + (model.PageIndex * model.PageSize);
            return this.unitOfWork.Current.QueryAsync<LookupValueModel>(query);
        }

        /// <inheritdoc />
        public Task<IEnumerable<LookupValueModel>> FetchSitesAsync(LookUpValueFilterModel model)
        {
            var where = " WHERE 1 = 1 AND";
            if (!string.IsNullOrEmpty(model.Name))
            {
                where += $@" ""Name"" ILIKE '%{model.Name}%' AND";
            }

            var query = $@"SELECT COUNT(*) OVER () AS ""TotalItems"", * from  ""LookupValue"" {where} ""LookupId"" = {5} Order by ""LookupValueId"" DESC";

            if (model.PageIndex <= 0)
            {
                return this.unitOfWork.Current.QueryAsync<LookupValueModel>(query);
            }

            model.PageIndex -= 1;
            query += " LIMIT " + model.PageSize + " offset " + (model.PageIndex * model.PageSize);
            return this.unitOfWork.Current.QueryAsync<LookupValueModel>(query);
        }

        /// <inheritdoc />
        public Task<IEnumerable<LookupValueModel>> FetchVaccinesAsync(LookUpValueFilterModel model)
        {
            var where = " WHERE 1 = 1 AND";
            if (!string.IsNullOrEmpty(model.Name))
            {
                where += $@" ""Name"" ILIKE '%{model.Name}%' AND";
            }

            var query = $@"SELECT COUNT(*) OVER () AS ""TotalItems"", * from  ""LookupValue"" {where} ""LookupId"" = {22} Order by ""LookupValueId"" DESC";

            if (model.PageIndex <= 0)
            {
                return this.unitOfWork.Current.QueryAsync<LookupValueModel>(query);
            }

            model.PageIndex -= 1;
            query += " LIMIT " + model.PageSize + " offset " + (model.PageIndex * model.PageSize);
            return this.unitOfWork.Current.QueryAsync<LookupValueModel>(query);
        }

        /// <inheritdoc />
        public async Task<int> DeleteProviderEncounterAsync(int id)
        {
            var query = $@"DELETE  FROM  ""ProviderEncounter"" WHERE ""ProviderGeneralAdviceId"" = { id } ";
            var record = await this.unitOfWork.Current.ExecuteAsync(query);
            return record;
        }

        /// <inheritdoc />
        public async Task<int> UpdateLookupValueAsync(LookupValueModel model)
        {
            var lookupValue = await this.unitOfWork.LookupValues.FindAsync(m => m.LookupValueId == model.LookupValueId);
            lookupValue.LookupValueId = model.LookupValueId;
            lookupValue.LookupId = model.LookupId;
            lookupValue.Name = model.Name;
            return await this.unitOfWork.LookupValues.UpdateAsync(lookupValue);
        }
    }
}
