﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class FloorModel
    {
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int FloorId { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string FloorName { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or Sets the Modified By Name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or Sets the Modified By Name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the multiple s location  id.
        /// </summary>
        public string LocationIds { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string? LocationNames { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }


        /// <summary>
        /// Gets or sets the location identifier.
        /// used to check whether user want to update its status or not.
        /// </summary>
        public Boolean UpdateStatus { get; set; }

    }
}
