﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The patient.
    /// </summary>
    public class PatientModel
    {
        /// <summary>
        /// Gets or sets the login id.
        /// </summary>
        public int? LoginLocationId { get; set; }
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted patient id.
        /// </summary>
        public string? EncryptedPatientId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public string? Salutation { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the first name.
        /// </summary>
        public string FirstName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the first name.
        /// </summary>
        public string AadharNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the middle name.
        /// </summary>
        public string? MiddleName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the last name.
        /// </summary>
        public string LastName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the father or husband.
        /// </summary>
        public string FatherOrHusband { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public short? Age { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public char? Gender { get; set; }

        /// <summary>
        /// Gets or sets the marital status.
        /// </summary>
        public char? MaritalStatus { get; set; }

        /// <summary>
        /// Gets or sets the umr.
        /// </summary>
        public string UMRNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string? Email { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string? Mobile { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the street address.
        /// </summary>
        public string? StreetAddress { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the address line 2.
        /// </summary>
        public string? AddressLine2 { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the city.
        /// </summary>
        public string? City { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the state.
        /// </summary>
        public string? State { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the Zipcode.
        /// </summary>
        public string? Zipcode { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the country name.
        /// </summary>
        public string? CountryName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the country code.
        /// </summary>
        public string? CountryCode { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the iso code.
        /// </summary>
        public string? ISOCode { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the profile image url.
        /// </summary>
        public string? ProfileImageUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string? ThumbnailUrl { get; set; } = string.Empty;


        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string? DocumentUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the base 64 profile image.
        /// </summary>
        public string? Base64ProfileImage { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the is locked.
        /// </summary>
        public bool? IsLocked { get; set; }

        /// <summary>
        /// Gets or sets the is active appointment exists.
        /// </summary>
        public bool? IsActiveAppointmentExists { get; set; }

        /// <summary>
        /// Gets or sets the is active admission exists.
        /// </summary>
        public bool? IsActiveAdmissionExists { get; set; }

        /// <summary>
        /// Gets or sets a value otp verified.
        /// </summary>
        public bool? OTPVerified { get; set; }

        /// <summary>
        /// Gets or sets a value manual verified.
        /// </summary>
        public bool? ManualVerified { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string? CreatedByName { get; set; }


        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string? ModifiedByName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the Referral Code.
        /// </summary>
        public string? ReferralCode { get; set; }

        /// <summary>
        /// Gets or sets the Referral Code.
        /// </summary>
        public int? ReferralBy { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int? DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is online.
        /// </summary>
        public bool? IsOnline { get; set; }

        /// <summary>
        /// Gets or sets a value whether patient is discharged.
        /// </summary>
        public bool? IsDischarged { get; set; }

        /// <summary>
        /// Gets or sets the discharge id.
        /// </summary>
        public int? DischargeId { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the RoleId.
        /// </summary>
        public short? RoleId { get; set; }

        /// <summary>
        /// Gets or sets the Referred by.
        /// </summary>
        public string? ReferredBy { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? ReferredByName { get; set; }

        /// <summary>
        /// Gets or sets the breakfast.
        /// </summary>
        /// <value>
        /// The breakfast.
        /// </value>
        public TimeSpan? Breakfast { get; set; }

        /// <summary>
        /// Gets or sets the lunch.
        /// </summary>
        /// <value>
        /// The lunch.
        /// </value>
        public TimeSpan? Lunch { get; set; }

        /// <summary>
        /// Gets or sets the dinner.
        /// </summary>
        /// <value>
        /// The dinner.
        /// </value>
        public TimeSpan? Dinner { get; set; }

        /// <summary>
        /// Gets or sets the breakfast.
        /// </summary>
        /// <value>
        /// The breakfast.
        /// </value>
        public TimeModelHelper? BreakfastTime { get; set; }

        /// <summary>
        /// Gets or sets the lunch.
        /// </summary>
        /// <value>
        /// The lunch.
        /// </value>
        public TimeModelHelper? LunchTime { get; set; }

        /// <summary>
        /// Gets or sets the dinner.
        /// </summary>
        /// <value>
        /// The dinner.
        /// </value>
        public TimeModelHelper? DinnerTime { get; set; }


        /// <summary>
        /// Gets or sets the Referral Code.
        /// </summary>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string? ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string? LocationName { get; set; }

        /// <summary>
        /// Gets or sets the filter
        /// </summary>
        public string? Filter { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail url.
        /// </summary>
        public string? PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the provider thumbnail url.
        /// </summary>
        public string? ProviderThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the HWC patient identifier.
        /// </summary>
        /// <value>
        /// The HWC patient identifier.
        /// </value>
        public int? HWCPatientId { get; set; }

        /// <summary>
        /// Gets or sets the name of the HWC.
        /// </summary>
        /// <value>
        /// The name of the HWC.
        /// </value>
        public string? HWCName { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        /// <value>
        /// The description.
        /// </value>
        public string? Description { get; set; }

        /// <summary>
        /// Gets or sets the color of the row.
        /// </summary>
        /// <value>
        /// The color of the row.
        /// </value>
        public string? RowColor { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Education { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Occupation { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? MartialStatus { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Religion { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Nationality { get; set; }

        ///// <summary>
        ///// Gets or sets the type of the pay.
        ///// </summary>
        ///// <value>
        ///// The type of the pay.
        ///// </value>
        //public string? PayType { get; set; } //as  paytypeid added 

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? IdProofId { get; set; }

        /// <summary>
        /// Gets or sets the id proof value.
        /// </summary>
        public string? IdProofValue { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public int? PatientReferredById { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Name { get; set; }

        /// <summary>
        /// Gets or sets the id proof name.
        /// </summary>
        public string? IdProofName { get; set; }
        /// <summary>
        /// Gets or sets the Pay type id from payType masters.
        /// </summary>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the Bill Number. //----lab bill no ---// for patient widget
        /// </summary>
        public string? BillNumber { get; set; }

        /// <summary>saw
        /// Gets or sets the Blood group
        /// </summary>
        public string? BloodGroup { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime? AppointmentDate { get; set; }

        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public bool? PaymentStatus { get; set; }

        /// <summary>
        ///  Gets or sets payment number.
        /// </summary>
        public string? PaymentNumber { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal? Amount { get; set; }

        /// <summary>
        /// Gets or sets the registration charges. 
        /// this value is used to add in Patient table (while inserting new patient either identify or unidentify patient.)
        /// </summary>
        public decimal? Charges { get; set; }

        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public bool? TempPatient { get; set; }

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? HowDidYouKnowId { get; set; }

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? EducationId { get; set; }

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? OccupationId { get; set; }
        /// <summary>
        /// Gets or sets the birthMark1.
        /// </summary>
        public string? BirthMark1 { get; set; }
        /// <summary>
        /// Gets or sets the birthMark1.
        /// </summary>
        public string? BirthMark2 { get; set; }
        /// <summary>
        /// Gets or sets the birthMark1.
        /// </summary>
        public string? EducationName { get; set; }
        /// <summary>
        /// Gets or sets the birthMark1.
        /// </summary>
        public string? OccupationName { get; set; }
        /// <summary>
        /// Gets or sets the birthMark1.
        /// </summary>
        public string? HowDidYouKnow { get; set; }

        /// <summary>
        /// Gets or sets the FTP Error Message.
        /// </summary>
        public string? ErrorMessage { get; set; }


        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string? TransactionId { get; set; }

        /// <summary>
        /// Gets or sets the transaction.
        /// </summary>
        public string Transaction { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public int? SalucroStatusCode { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string? SalucroTransactionId { get; set; }


        /// <summary>
        /// Gets or sets the type of the relation.
        /// </summary>
        /// <value>
        /// The type of the relation.
        /// </value>
        public string? RelationType { get; set; }

        /// <summary>
        /// Gets or sets the occupation detail.
        /// </summary>
        /// <value>
        /// The occupation detail.
        /// </value>
        public string? OccupationDetail { get; set; }
        /// <summary>
        /// Gets or sets the is new patient.
        /// </summary>
        /// <value>
        /// The is new patient.
        /// </value>
        public bool IsNewPatient { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public int? PaymentInitiationLogId { get; set; }

        /// <summary>
        /// Gets or sets the relative name.
        /// </summary>
        public string? RelativeName { get; set; }
        /// <summary>
        /// Gets or sets the relation.
        /// </summary>
        public string? Relation { get; set; }
        /// <summary>
        /// Gets or sets the area.
        /// </summary>
        public string? Area { get; set; }

        /// <summary>
        /// Gets or sets the MR number.
        /// </summary>
        /// <value>
        /// The MR no.
        /// </value>
        public int? MRNO { get; set; }

        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public bool? SaveRelativeAsPatient { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? InsuranceId { get; set; }

        /// <summary>
        /// Gets or sets the insurance company id.
        /// </summary>
        public int? InsuranceCompanyId { get; set; }

        /// <summary>
        /// Gets or sets the other remarks.
        /// </summary>
        public string OtherRemarks { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentTimeString
        /// </summary>
        public string? AppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentEndTime { get; set; }

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string? EncryptedProviderId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the specialization id.
        /// </summary>
        public int SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the department name.
        /// </summary>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the specialization name.
        /// </summary>
        public string SpecializationName { get; set; }

        /// <summary>
        /// Gets or sets the token number.
        /// </summary>
        public int TokenNumber { get; set; }

        /// <summary>
        /// Gets or sets the practice name. 
        /// </summary>
        public string? PracticeName { get; set; }

        /// <summary>
        /// Gets or sets the provider location.
        /// </summary>
        public string? ProviderLocation { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public DateTime? LastConsultedDate { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public string? LastConsultedDoctor { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public decimal? LastPaidAmount { get; set; }

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public string? NextAppointment { get; set; }

        /// <summary>
        /// Gets or sets the last appointment time.
        /// </summary>
        public string? LastConsultedTime { get; set; }


        /// <summary>
        ///  Gets or sets patient payment status.
        /// </summary>
        public bool? PatientPaymentStatus { get; set; }

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string? EncryptedAppointmentId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the appointment payment status.
        /// </summary>
        public bool AppointmentPaymentStatus { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string PatientType { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string AppointmentNotes { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int CouponId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public decimal Discount { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string PaymentType { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int VisitTypeId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int ChargeTypesId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int AppointmentTypeId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int ChargeTySpecializationIdpesId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int ProviderAvailabilityId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int ConsultationTypeId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int DoctorSpecializationChargeModuleDetailsId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int AuthorityMasterId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string Remarks { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int ReasonsId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal? AppointmentAmount { get; set; }

        /// <summary>
        /// Gets or sets the module name.
        /// </summary>
        public string? ModuleName { get; set; }

        /// <summary>
        /// Gets or sets the insurance company id.
        /// </summary>
        public string? InsuranceCompany { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? ReferredByNameId { get; set; }

        /// <summary>
        /// Gets or sets the insurance company id.
        /// </summary>
        public string? REGNO { get; set; }
        public string RelativeEducation { get; set; }
        public string RelativeOccupation { get; set; }

        /// <summary>
        /// Get or sets the total.
        /// </summary>
        public decimal DiscountInPercentage { get; set; }

        /// <summary>
        /// Get or sets the total.
        /// </summary>
        public decimal DiscountInRupees { get; set; }

        /// <summary>
        /// Gets or sets the patient total.
        /// </summary>
        public decimal? PatientTotal { get; set; }

        /// <summary>
        /// Gets or sets from.
        /// </summary>
        /// <value>
        /// From.
        /// </value>
        public string From { get; set; }
        public bool IsBabyRegistration { get; set; }
        public int? ParentPatientId { get; set; }
        /// <summary>
        /// Gets or sets the admission time.
        /// </summary>
        public TimeSpan? TimeOfBirth { get; set; }
        /// <summary>
        /// Gets or sets the guid.
        /// </summary>
        public Guid Guid { get; set; }
    }
}
