﻿namespace Hims.Shared.Library.Enums
{
    /// <summary>
    /// The account type.
    /// </summary>
    public enum TimelineAction
    {
        /// <summary>
        /// The super admin.
        /// </summary>
        DocumentAdded = 1,

        /// <summary>
        /// The admin.
        /// </summary>
        DocumentEdited = 2,

        /// <summary>
        /// The provider.
        /// </summary>
        DocumentDeleted = 3,

        /// <summary>
        /// The internal medicine added.
        /// </summary>
        InternalMedicineAdded = 4,

        /// <summary>
        /// The internal medicine updated.
        /// </summary>
        InternalMedicineUpdated = 5,

        /// <summary>
        /// The internal medicine deleted.
        /// </summary>
        InternalMedicineDeleted = 6,

        /// <summary>
        /// The appointment added.
        /// </summary>
        AppointmentAdded = 7,

        /// <summary>
        /// The medications added.
        /// </summary>
        MedicationsAdded = 8,

        /// <summary>
        /// The medications updated.
        /// </summary>
        MedicationsUpdated = 9,

        /// <summary>
        /// The notes added.
        /// </summary>
        NotesAdded = 10,

        /// <summary>
        /// The notes updated.
        /// </summary>
        NotesUpdated = 11,

        /// <summary>
        /// The follow up added.
        /// </summary>
        FollowUpAdded = 12,

        /// <summary>
        /// The follow up updated.
        /// </summary>
        FollowUpUpdated = 13,
        /// <summary>
        /// The follow up updated.
        /// </summary>
        EncounterAdded = 14,
        /// <summary>
        /// The cross consultation.
        /// </summary>
        CrossConsultation = 15


    }
}
