﻿namespace Hims.Shared.UserModels.Pharmacy
{
    using System;

    /// <summary>
    /// The pharmacy sale bill.
    /// </summary>
    public class PharmacyProductProfit
    {

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int? PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product Name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy retail stock id.
        /// </summary>
        public int PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the purchase  rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the Quantity in.
        /// </summary>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the Quantity Out
        public int QuantityOut { get; set; }

        /// <summary>
        /// Gets or sets the Supplier id.
        /// </summary>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the Supplier Name.
        /// </summary>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the Retail Pharmacyid.
        /// </summary>
        public int? RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the Retail Name.
        /// </summary>
        public string RetailName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

    }
}
