﻿namespace Hims.Domain.Entities
{
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The discounts per module.
    /// </summary>
    public class DiscountsPerModule
    {
        /// <summary>
        /// Gets or sets the discounts per module id.
        /// </summary>
        [Key, Identity]
        public int DiscountsPerModuleId { get; set; }

        /// <summary>
        /// Gets or sets the discounts module id.
        /// </summary>
        public int DiscountModuleId { get; set; }

        /// <summary>
        /// Gets or sets the role id.
        /// </summary>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the allowed percentage.
        /// </summary>
        public int AllowedPercentage { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }
    }
}
