﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The account.
    /// </summary>
    public class ModulesMaster
    {

        /// <summary>
        /// Gets or sets the ModulesMasterId.
        /// </summary>
        [Key, Identity]
        public int ModulesMasterId { get; set; }

        /// <summary>
        /// Gets or sets the ModuleName.
        /// </summary>
        public string ModuleName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the ModuleIcon.
        /// </summary>

        public string ModuleIcon { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the ModuleDescription.
        /// </summary>
        public string ModuleDescription { get; set; } = string.Empty;
        /// Gets or sets the last created by.
        /// </summary>

        /// </summary>

        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
      
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
     
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the type of the package.
        /// </summary>
        /// <value>
        /// The type of the package.
        /// </value>
        public string? PackageType { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is charge category applicable.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is charge category applicable; otherwise, <c>false</c>.
        /// </value>
        public bool IsChargeCategoryApplicable { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is doctor charge category applicable.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is doctor charge category applicable; otherwise, <c>false</c>.
        /// </value>
        public bool IsDoctorChargeCategoryApplicable { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is package applicable.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is package applicable; otherwise, <c>false</c>.
        /// </value>
        public bool IsPackageApplicable { get; set; }
    }
}