﻿using Hims.Shared.Dapper.Attributes;
using System.ComponentModel.DataAnnotations;

namespace Hims.Domain.Entities.Pharmacy
{

    /// <summary>
    /// The pharmacy department issue detail.
    /// </summary>
    public class PharmacyDepartmentIssueDetail
    {
        /// <summary>
        /// Gets or sets the pharmacy department issue detail identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department issue detail identifier.
        /// </value>
        [Key, Identity]
        public long PharmacyDepartmentIssueDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy department issue header identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department issue header identifier.
        /// </value>
        public long PharmacyDepartmentIssueHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy department indent detail identifier.
        /// </summary>
        /// <value>
        /// The pharmacy department indent detail identifier.
        /// </value>
        public long PharmacyDepartmentIndentDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product identifier.
        /// </summary>
        /// <value>
        /// The pharmacy product identifier.
        /// </value>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy retail stock identifier.
        /// </summary>
        /// <value>
        /// The pharmacy retail stock identifier.
        /// </value>
        public int PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the approved quantity.
        /// </summary>
        /// <value>
        /// The approved quantity.
        /// </value>
        public int ApprovedQuantity { get; set; }
    }
}
