﻿namespace Hims.Domain.Entities.Vaccine
{
    using Hims.Shared.Dapper.Attributes;
    using System.ComponentModel.DataAnnotations;

    /// <summary>
    /// The vaccine type.
    /// </summary>
    public class VaccineType
    {
        /// <summary>
        /// Gets or sets the vaccine type identifier.
        /// </summary>
        /// <value>
        /// The vaaccine type identifier.
        /// </value>
        [Key,Identity]
        public int VaccineTypeId { get; set; }

        /// <summary>
        /// Gets or sets the name of the type.
        /// </summary>
        /// <value>
        /// The name of the type.
        /// </value>
        public string TypeName { get; set; }

        /// <summary>
        /// Gets or sets the color of the row.
        /// </summary>
        /// <value>
        /// The color of the row.
        /// </value>
        public string RowColor { get; set; }
    }
}
