﻿#nullable enable
namespace Hims.Domain.Helpers
{
    using System;
    using System.Threading.Tasks;
    using RestSharp;
    using Shared.EntityModels;

    /// <summary>
    /// The sinch interface.
    /// </summary>
    public interface ISMSHelper
    {
        /// <summary>
        /// The send SMS async.
        /// </summary>
        /// <param name="mobile">
        ///     The mobile.
        /// </param>
        /// <param name="body">
        ///     The body.
        /// </param>
        /// <param name="countryModel">
        ///     The country Model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IRestResponse?> SendSMSAsync(string mobile, string body, CountryModel countryModel);

        /// <summary>
        /// Sends the lab report SMS asynchronous.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="body">The body.</param>
        /// <param name="countryModel">The country model.</param>
        /// <param name="url">The URL.</param>
        /// <returns></returns>
        Task<Tuple<IRestResponse, string>> SendLabReportSMSAsync(string mobile, string body, CountryModel countryModel, string url);
        Task<Tuple<IRestResponse, string>> SendPdfLinkSMSAsync(string patientMobile, string messageBody, CountryModel countryModel, string createPdfLink);
    }
}
