﻿using Hims.Domain.Entities;
using Hims.Shared.EntityModels;
using Hims.Shared.UserModels;
using Hims.Shared.UserModels.Filters;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Domain.Services
{
    public interface IEncountersLogService 
    {
        /// <summary>
        /// The fetch async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<IEnumerable<EncountersLogModel>> FetchAsync(EncountersLogModel model);

        /// <summary>
        /// The add async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task LogAsync(EncountersLogModel model);
        /// <summary>
        /// The get patient  details.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointmentId.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<PatientModel> GetPatientDetails(int appointmentId);
    }
}
